/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.sound;

import dan200.computercraft.client.sound.DfpwmStream;
import dan200.computercraft.shared.peripheral.speaker.SpeakerPosition;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import org.jspecify.annotations.Nullable;

public class SpeakerSound
extends AbstractSoundInstance
implements TickableSoundInstance {
    @Nullable DfpwmStream stream;
    private @Nullable Entity entity;
    private boolean stopped = false;

    SpeakerSound(ResourceLocation sound, @Nullable DfpwmStream stream, SpeakerPosition position, float volume, float pitch) {
        super(sound, SoundSource.RECORDS, SoundInstance.createUnseededRandom());
        this.setPosition(position);
        this.stream = stream;
        this.volume = volume;
        this.pitch = pitch;
        this.attenuation = SoundInstance.Attenuation.LINEAR;
    }

    void setPosition(SpeakerPosition position) {
        this.x = position.position().x;
        this.y = position.position().y;
        this.z = position.position().z;
        this.entity = position.entity();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void tick() {
        if (this.entity == null) {
            return;
        }
        if (!this.entity.isAlive()) {
            this.stopped = true;
            this.looping = false;
        } else {
            this.x = this.entity.getX();
            this.y = this.entity.getY();
            this.z = this.entity.getZ();
        }
    }

    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary soundBuffers, Sound sound, boolean looping) {
        return this.getAudioStream(soundBuffers, sound.getPath(), looping);
    }

    public CompletableFuture<AudioStream> getAudioStream(SoundBufferLibrary soundBuffers, ResourceLocation sound, boolean looping) {
        return this.stream != null ? CompletableFuture.completedFuture(this.stream) : soundBuffers.getStream(sound, looping);
    }

    public @Nullable AudioStream getStream() {
        return this.stream;
    }

    boolean setVolume(float volume) {
        if (volume == this.volume) {
            return false;
        }
        this.volume = volume;
        return true;
    }
}

